package editor;

import game.CustomImageData;
import game.CustomImageDataII;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;

import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CustomAnimationPanel extends JPanel implements AnimationPanel {

	PreviewCanvas hugePreviewScreen = null;
	JList listComponent = null;
	DefaultListModel listModel = null;
	
	JTextArea totalFrameCount = null;
	
	JDialog parent = null;
	
//	private JTabbedPane tabsToJumpTo[] = null;
//	private int indexesToJumpTo[] = null;
	
	private JButton previewButton;
	private JButton clearAllButton;
	private JButton browseImageButton;
	private JButton removeImageButton;
	private JButton upButton;
	private JButton downButton;
	private JButton changeFrameCountButton;
	
	
	
	private BackdropListedImage backdropImages[] = null;
	private int backdropImageIndex = 0;
	private static final int MAX_BACKDROP_IMAGE = 20;
	
	private MiniColorCanvas backgroundColorCanvas = null;
	
	
	private JComboBox backdropList = null;
	private DefaultComboBoxModel backdropListModel = null;
	
	private JTextArea widthTextArea = null;
	private JButton widthSetButton = null;
	private JTextArea heightTextArea = null;
	private JButton heightSetButton = null;
	
	private Color defaultTransparentColor = null;
	
	
	private CustomImageDataII finalResult[] = null;
	
	private SecondaryOKValidation additionalValidations;
	
	private ListedCustomImage clipboard = null;
	
	
	public CustomAnimationPanel (JDialog theParent, 
            String labelAddition,
            String caption) {
		this(theParent, labelAddition, caption, true);
	}
	
	public CustomAnimationPanel (JDialog theParent, 
			                     String labelAddition,
			                     String caption, 
			                     boolean shouldHaveOkCancelButtons) {
		
		parent = theParent;
		
//		tabsToJumpTo = theTabbedPaneArray;
//		indexesToJumpTo = theIndexArray;
		
		backdropImages = new BackdropListedImage[23];
		
		ImageIcon tempIcon = null;
		ImageIcon tempPrevIcon = null;
		BackdropListedImage tempImage = null;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_check.GIF"));
		tempImage = new BackdropListedImage("Silver&White L", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[0] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_mini_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_mini_check.GIF"));
		tempImage = new BackdropListedImage("Silver&White M", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[1] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_micro_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_micro_check.GIF"));
		tempImage = new BackdropListedImage("Silver&White S", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[2] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_check.GIF"));
		tempImage = new BackdropListedImage("Black&White L", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[3] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_mini_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_mini_check.GIF"));
		tempImage = new BackdropListedImage("Black&White M", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[4] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_micro_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_micro_check.GIF"));
		tempImage = new BackdropListedImage("Black&White S", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[5] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_check.GIF"));
		tempImage = new BackdropListedImage("Red&Cyan L", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[6] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_mini_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_mini_check.GIF"));
		tempImage = new BackdropListedImage("Red&Cyan M", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[7] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_micro_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_micro_check.GIF"));
		tempImage = new BackdropListedImage("Red&Cyan S", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[8] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_check.GIF"));
		tempImage = new BackdropListedImage("Yellow&Blue L", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[9] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_mini_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_mini_check.GIF"));
		tempImage = new BackdropListedImage("Yellow&Blue M", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[10] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_micro_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_micro_check.GIF"));
		tempImage = new BackdropListedImage("Yellow&Blue S", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[11] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_check.GIF"));
		tempImage = new BackdropListedImage("Green&Magenta L", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[12] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_mini_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_mini_check.GIF"));
		tempImage = new BackdropListedImage("Green&Magenta M", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[13] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_micro_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_micro_check.GIF"));
		tempImage = new BackdropListedImage("Green&Magenta S", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[14] = tempImage;
		
		
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/white.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_white.GIF"));
		tempImage = new BackdropListedImage("Solid White", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[15] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black.GIF"));
		tempImage = new BackdropListedImage("Solid Black", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[16] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red.GIF"));
		tempImage = new BackdropListedImage("Solid Red", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[17] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow.GIF"));
		tempImage = new BackdropListedImage("Solid Yellow", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[18] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green.GIF"));
		tempImage = new BackdropListedImage("Solid Lime", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[19] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/cyan.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_cyan.GIF"));
		tempImage = new BackdropListedImage("Solid Cyan", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[20] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/blue.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_blue.GIF"));
		tempImage = new BackdropListedImage("Solid Blue", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[21] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/magenta.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_magenta.GIF"));
		tempImage = new BackdropListedImage("Solid Magenta", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[22] = tempImage;
		
		
		
		BorderLayout borderLayout = new BorderLayout();
		
		this.setLayout(borderLayout);
		
		JPanel middlePanel = new JPanel();
		JPanel middleLeftPanel = new JPanel();
		JPanel middleLeftInnerPanel = new JPanel();
		JPanel middleLeftLowerPanel = new JPanel();
		JPanel middleRightPanel = new JPanel();
		JPanel middleRightInnerPanel = new JPanel();
		JPanel middleRightLowerPanel = new JPanel();
		
		GridLayout gridLayout = new GridLayout(1, 2);
		BorderLayout borderLayoutLeft = new BorderLayout();
		GridBagLayout gridLayoutLeftLower = new GridBagLayout();
		BorderLayout borderLayoutRight = new BorderLayout();
		GridBagLayout gridLayoutRightLower = new GridBagLayout();
		FlowLayout flowLayoutLeft = new FlowLayout();
		FlowLayout flowLayoutRight = new FlowLayout();
		FlowLayout flowLayoutUpper = new FlowLayout();
		
		middlePanel.setLayout(gridLayout);
		
		hugePreviewScreen = new PreviewCanvas(false, this, false);
		hugePreviewScreen.setBackdropImage(backdropImages[0].getImage());
//		hugePreviewScreen.setAlignmentX(JLabel.CENTER_ALIGNMENT);
//		hugePreviewScreen.setAlignmentY(JLabel.CENTER_ALIGNMENT);
//		
//		
//		hugePreviewScreen.setPreferredSize(new Dimension(200, 200));
//		hugePreviewScreen.setMinimumSize(new Dimension(200, 200));
//		hugePreviewScreen.setMaximumSize(new Dimension(200, 200));
		
//		Border hugePreviewScreenBorder = BorderFactory.createLineBorder(new Color(0,0,0));
//		
//		hugePreviewScreen.setBorder(hugePreviewScreenBorder);
		
		
		listModel = new DefaultListModel();
		listComponent = new JList(listModel);
		listComponent.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		listComponent.addListSelectionListener(new ListSelectionListener() {
			
			public void valueChanged(ListSelectionEvent arg0) {
				// TODO Auto-generated method stub
				
				listSelectionChanged();
			}
			
		});
		listComponent.addKeyListener(new KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				if(!e.isControlDown())
					return;
				if(e.getKeyCode() == KeyEvent.VK_C) {
					copyImage();
				} else if(e.getKeyCode() == KeyEvent.VK_V) {
					pasteImage();
				}
			}
		});
		
		
		JScrollPane listPane = new JScrollPane();
		listPane.setPreferredSize(new Dimension(200,200));
		listPane.setMinimumSize(new Dimension(200, 200));
		listPane.setMaximumSize(new Dimension(200, 200));
		
		listPane.getViewport().setView(listComponent);
		
		
		LineBorder innerLineBorderLeft = (LineBorder) BorderFactory.createLineBorder(new Color(140, 140, 140));
		TitledBorder titleBorderLeft = new TitledBorder(innerLineBorderLeft, "Frame Preview", TitledBorder.LEFT, TitledBorder.TOP);
		
		middleLeftInnerPanel.setBorder(titleBorderLeft);
		middleLeftInnerPanel.setLayout(flowLayoutLeft);
		middleLeftInnerPanel.add(hugePreviewScreen);
		
		GridBagLayout gbl1 = new GridBagLayout();
		GridBagConstraints gbc1 = new GridBagConstraints();
		
		gbc1.fill = GridBagConstraints.BOTH;
		
		gbc1.gridwidth = GridBagConstraints.REMAINDER;
		gbc1.weightx = 0.0;
		gbc1.weighty = 0.0;
		
		
		
		//middleLeftPanel.setLayout(borderLayoutLeft);
		//middleLeftPanel.add(middleLeftInnerPanel, BorderLayout.CENTER);
		
		middleLeftPanel.setLayout(gbl1);
		
		gbl1.setConstraints(middleLeftInnerPanel, gbc1);
		
		middleLeftPanel.add(middleLeftInnerPanel);
		
		
		
		middleLeftPanel.setPreferredSize(new Dimension(200, 200));
		middleLeftPanel.setMinimumSize(new Dimension(200, 200));
		middleLeftPanel.setMaximumSize(new Dimension(200, 200));
		
		middleLeftLowerPanel.setLayout(gridLayoutLeftLower);
		previewButton = new JButton("Preview...");
		
		
		ActionListener previewListener = new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				popUpPreviewWindow();
			}
		};
		previewButton.addActionListener(previewListener);
		
		JPanel previewAndClearPanel = new JPanel();
		
		previewAndClearPanel.setLayout(new GridLayout(1, 2));
		
//		Border innerPreviewClearBorder = BorderFactory.createLineBorder(new Color(255, 0, 0));
//		TitledBorder previewAndClearBorder = BorderFactory.createTitledBorder(innerPreviewClearBorder, "previewAndClearPanel");
//		
//		previewAndClearPanel.setBorder(previewAndClearBorder);
		
		JPanel previewPanel = new JPanel();
		previewPanel.setLayout(new FlowLayout());
		previewPanel.add(previewButton);
		previewAndClearPanel.add(previewPanel);
		

		clearAllButton = new JButton("Clear All");
		clearAllButton.setAlignmentX(JButton.CENTER_ALIGNMENT);
		
		ActionListener clearAllListener = new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				removeAllImagesFromList();
				hugePreviewScreen.setListedImage(null);
				hugePreviewScreen.refresh();
				
			}
			
		};
		clearAllButton.addActionListener(clearAllListener);
		
		JPanel clearAllPanel = new JPanel(new FlowLayout());
		

//		Border innerClearAllBorder = BorderFactory.createLineBorder(new Color(255, 255, 0));
//		TitledBorder clearAllBorder = BorderFactory.createTitledBorder(innerClearAllBorder, "clearAllPanel");
//		
//		clearAllPanel.setBorder(clearAllBorder);
		
		clearAllPanel.add(clearAllButton);
		previewAndClearPanel.add(clearAllPanel);
		
		
		
		
		GridBagConstraints gridLayoutLeftLowerConstraints = new GridBagConstraints();
		
		gridLayoutLeftLowerConstraints.weightx = 1.0;
		gridLayoutLeftLowerConstraints.weighty = 1.0;
		gridLayoutLeftLowerConstraints.gridwidth = GridBagConstraints.REMAINDER;
		gridLayoutLeftLowerConstraints.fill = GridBagConstraints.BOTH;
		
		
		
		
		gbc1.weighty = 1.0;
		//gbc1.gridheight = GridBagConstraints.REMAINDER;
		
		gridLayoutLeftLower.setConstraints(previewAndClearPanel,gridLayoutLeftLowerConstraints);
		
		middleLeftLowerPanel.add(previewAndClearPanel);
		
		JPanel colorAndDimensionsPanel = new JPanel();
		colorAndDimensionsPanel.setLayout(new GridLayout(4,1));
		
		//colorAndDimensionsPanel.add(new JLabel("the text areas go here"));
		
		GridBagLayout backdropSelectorLayout = new GridBagLayout();
		JPanel backdropSelectorPanel = new JPanel(backdropSelectorLayout);
		
		GridBagConstraints backdropSelectorConstraints = new GridBagConstraints();
		
		backdropSelectorConstraints.fill = GridBagConstraints.BOTH;
		
		backdropSelectorConstraints.gridwidth = GridBagConstraints.RELATIVE;
		backdropSelectorConstraints.weightx = 1.0;
		backdropSelectorConstraints.weighty = 0.0;
		
		JPanel backdropLabelPanel = new JPanel(new FlowLayout());
		backdropLabelPanel.add(new JLabel("Backdrop: "));
		
		backdropSelectorLayout.setConstraints(backdropLabelPanel, backdropSelectorConstraints);
		backdropSelectorPanel.add(backdropLabelPanel);
		
		backdropSelectorConstraints.gridwidth = GridBagConstraints.REMAINDER;
		backdropSelectorConstraints.weightx = 3.0;
		backdropSelectorConstraints.weighty = 0.0;
		
		JPanel backdropListPanel = new JPanel(new FlowLayout());
		
		backdropListModel = new DefaultComboBoxModel();
		backdropList = new JComboBox(backdropListModel);
		backdropListPanel.add(backdropList);
		
		for(ListedImage li : backdropImages) {
			backdropListModel.addElement(li);
		}
		
		backdropList.addItemListener(new ItemListener() {

			public void itemStateChanged(ItemEvent arg0) {
				
//				System.out.println("now in itemStateChanged!");
				
				int index = backdropList.getSelectedIndex();
				if(index < 0)
					index = 0;
				
				ListedImage li = (ListedImage) backdropListModel.getElementAt(index);
				
//				System.out.println("li's name is: " + li.getFileName());
				
				hugePreviewScreen.setBackdropImage(li.getImage());
				listSelectionChanged();
			}
			
		});
		
		backdropSelectorLayout.setConstraints(backdropListPanel, backdropSelectorConstraints);
		
		backdropSelectorPanel.add(backdropListPanel);
		
		colorAndDimensionsPanel.add(backdropSelectorPanel);
		
		GridBagLayout colorPopupLayout = new GridBagLayout();
		JPanel colorPopupPanel = new JPanel(colorPopupLayout);
		
		JPanel colorButtonPanel = new JPanel(new FlowLayout());
		JButton colorPopupButton = new JButton("Set BgColor...");
		colorPopupButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				popUpColorSelectDialog();
			}
			
		});
		colorButtonPanel.add(colorPopupButton);
		
		
		GridBagConstraints colorPopupConstraints = new GridBagConstraints();

		colorPopupConstraints.fill = GridBagConstraints.BOTH;
		
		colorPopupConstraints.gridwidth = GridBagConstraints.RELATIVE;
		colorPopupConstraints.weightx = 1.0;
		colorPopupConstraints.weighty = 0.0;
		
		colorPopupLayout.setConstraints(colorButtonPanel, colorPopupConstraints);
		
		colorPopupPanel.add(colorButtonPanel);
		
		colorPopupConstraints.gridwidth = GridBagConstraints.REMAINDER;
		colorPopupConstraints.weightx = 1.0;
		
		backgroundColorCanvas = new MiniColorCanvas(listComponent, listModel);
		Border loweredBorder = BorderFactory.createEtchedBorder();
		backgroundColorCanvas.setBorder(loweredBorder);
		
		colorPopupLayout.setConstraints(backgroundColorCanvas, colorPopupConstraints);
		colorPopupPanel.add(backgroundColorCanvas);
		
		colorAndDimensionsPanel.add(colorPopupPanel);
		
		JPanel widthPanel = new JPanel(new GridLayout(1, 3));
		widthPanel.add(new JLabel("Width:"));
		JPanel widthTextPanel = new JPanel(new FlowLayout());
		widthTextArea = new JTextArea();
		widthTextArea.setPreferredSize(new Dimension(60, 21));
		widthTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
		widthTextPanel.add(widthTextArea);
		
		widthTextArea.addFocusListener(new FocusListener() {

			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub
				
			}

			public void focusLost(FocusEvent arg0) {
//				System.out.println("lost the focus just now!");
			}
			
		});
		
		
		widthPanel.add(widthTextPanel);
		JPanel widthSetPanel = new JPanel(new FlowLayout());
		widthSetButton = new JButton("Set");
		widthSetButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				onClickSetWidth();
			}
		});
		widthSetPanel.add(widthSetButton);
		widthPanel.add(widthSetPanel);
		colorAndDimensionsPanel.add(widthPanel);  
		
		JPanel heightPanel = new JPanel(new GridLayout(1, 3));
		heightPanel.add(new JLabel("Height:"));
		JPanel heightTextPanel = new JPanel(new FlowLayout());
		heightTextArea = new JTextArea();
		heightTextArea.setPreferredSize(new Dimension(60, 21));
		heightTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
		heightTextPanel.add(heightTextArea);
		heightPanel.add(heightTextPanel);
		JPanel heightSetPanel = new JPanel(new FlowLayout());
		heightSetButton = new JButton("Set");
		heightSetButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				onClickSetHeight();
			}
		});
		heightSetPanel.add(heightSetButton);
		heightPanel.add(heightSetPanel);
		colorAndDimensionsPanel.add(heightPanel);
		
		
		gridLayoutLeftLower.setConstraints(colorAndDimensionsPanel, gridLayoutLeftLowerConstraints);
		
		middleLeftLowerPanel.add(colorAndDimensionsPanel);

		gbl1.setConstraints(middleLeftLowerPanel, gbc1);
		
//		middleLeftPanel.add(middleLeftLowerPanel, BorderLayout.SOUTH);
		middleLeftPanel.add(middleLeftLowerPanel);
		
		middlePanel.add(middleLeftPanel);
		
		middleRightPanel = new JPanel();
//		middleRightPanel.setLayout(borderLayoutRight);
		
		GridBagLayout gbl2 = new GridBagLayout();
		GridBagConstraints gbc2 = new GridBagConstraints();
		
		
		
		middleRightPanel.setLayout(gbl2);
		
		middleRightInnerPanel.setLayout(flowLayoutRight);
		middleRightInnerPanel.add(listPane);
		
		LineBorder innerLineBorderRight = (LineBorder) BorderFactory.createLineBorder(new Color(140, 140, 140));
		TitledBorder titleBorderRight = new TitledBorder(innerLineBorderRight, "List of Frames", TitledBorder.LEFT, TitledBorder.TOP);
		
		middleRightInnerPanel.setBorder(titleBorderRight);
		
//		middleRightPanel.add(middleRightInnerPanel, BorderLayout.CENTER);
		
		gbc2.fill = GridBagConstraints.BOTH;
		gbc2.gridwidth = GridBagConstraints.REMAINDER;
		gbc2.weightx = 0.0;
		gbc2.weighty = 0.0;
		
		gbl2.setConstraints(middleRightInnerPanel, gbc2);
		
		middleRightPanel.add(middleRightInnerPanel);
		GridBagConstraints gbc3 = new GridBagConstraints();
		
		middleRightLowerPanel.setLayout(gridLayoutRightLower);
				
		browseImageButton = new JButton("Browse...");
		browseImageButton.setEnabled(false);
		removeImageButton = new JButton("Clear Image");
		removeImageButton.setEnabled(false);
		
		JPanel selectImagePanel = new JPanel();
		selectImagePanel.setLayout(new FlowLayout());
		
		ActionListener selectImageListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				selectImageIntoList();
			}
		};
		
		browseImageButton.addActionListener(selectImageListener);
		
		selectImagePanel.add(browseImageButton);
		JPanel removeImagePanel = new JPanel();
		removeImagePanel.setLayout(new FlowLayout());
		
		ActionListener removeImageListener = new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				removeImageFromList();
				hugePreviewScreen.setListedImage(null);
				hugePreviewScreen.refresh();
			}
			
		};
		removeImageButton.addActionListener(removeImageListener);
		
		removeImagePanel.add(removeImageButton);
		
		
		JPanel selectMultipleFilesPanel = new JPanel(new FlowLayout());
		JButton selectMultipleFilesButton = new JButton("Multiple Files...");
		selectMultipleFilesButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				JFileChooser jfc = new JFileChooser();
				jfc.setMultiSelectionEnabled(true);
				
				int result = jfc.showOpenDialog(parent);
				
				if(result == JFileChooser.APPROVE_OPTION) {
					
					result = JOptionPane.showConfirmDialog(parent, "This will clear out everything, and replace it with the files that were loaded.  Continue?","Confirm load multiple files", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
					if(result == JOptionPane.NO_OPTION)
						return;
					
					
					File fileArray[] = jfc.getSelectedFiles();
					
					
					
					
					ArrayList<ListedCustomImage> newImages = new ArrayList<ListedCustomImage>();
					ListedCustomImage newImage = null;
					BufferedImage bi = null;
					for(File f : fileArray) {
//						System.out.println("A file: " + f.getAbsolutePath());
						try {
							bi = ImageIO.read(f);
						} catch(Exception e) {
							JOptionPane.showMessageDialog(parent, "Error while trying to load image file: " + f.getAbsolutePath(),"Error loading image",JOptionPane.WARNING_MESSAGE);
							return;
						}
						newImage = new ListedCustomImage(bi, bi.getWidth(), bi.getHeight(), null, parent, f.getAbsolutePath());
						newImages.add(newImage);
					}
					
					
					totalFrameCount.setText(Integer.toString(fileArray.length));
					uponPanelCountChange();
					
					for(int i = 0; i < newImages.size(); i++) {
						listModel.setElementAt(newImages.get(i), i);
					}
					
					
					
				}
				
			}
		});
		selectMultipleFilesPanel.add(selectMultipleFilesButton);
		
		
		gbc3.fill = GridBagConstraints.BOTH;
		gbc3.gridwidth = GridBagConstraints.RELATIVE;
		gbc3.weightx = 1.0;
		gbc3.weighty = 1.0;
		
		gridLayoutRightLower.setConstraints(selectImagePanel, gbc3);
		middleRightLowerPanel.add(selectImagePanel);
		gbc3.gridwidth = GridBagConstraints.REMAINDER;
		gridLayoutRightLower.setConstraints(removeImagePanel, gbc3);
		middleRightLowerPanel.add(removeImagePanel);
		
		
		JPanel upAndDownPanel = new JPanel();
		GridLayout upAndDownLayout = null;
		
		if(caption == null) {
			upAndDownLayout = new GridLayout(4,1);
			upAndDownPanel.setLayout(upAndDownLayout);
		} else {
			upAndDownLayout = new GridLayout(5, 1);
			upAndDownPanel.setLayout(upAndDownLayout);
			
			JLabel captionLabel = new JLabel(caption);
			upAndDownPanel.add(captionLabel);
		}
		
		
		
		
		
		upButton = new JButton("Move Image Up");
		upButton.setEnabled(false);
		JPanel upButtonPanel = new JPanel();
		
		ActionListener upButtonListener = new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				moveImageUp();
			}
		};
		
		upButton.addActionListener(upButtonListener);
		
		
		
		FlowLayout upButtonLayout = new FlowLayout();
		upButtonPanel.setLayout(upButtonLayout);
		upButtonPanel.add(upButton);
		
		downButton = new JButton("Move Image Down");
		downButton.setEnabled(false);
		JPanel downButtonPanel = new JPanel();
		
		ActionListener downButtonListener = new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				moveImageDown();
			}
		};
		downButton.addActionListener(downButtonListener);
		
		
		FlowLayout downButtonLayout = new FlowLayout();
		downButtonPanel.setLayout(downButtonLayout);
		downButtonPanel.add(downButton);
		
		upAndDownPanel.add(upButtonPanel);
		upAndDownPanel.add(downButtonPanel);
		
		upAndDownPanel.add(new JPanel());
		upAndDownPanel.add(selectMultipleFilesPanel); 
		
		gbc3.weightx = 2.0;
		
		gridLayoutRightLower.setConstraints(upAndDownPanel, gbc3);
		
		middleRightLowerPanel.add(upAndDownPanel);
		
		
//		middleRightPanel.add(middleRightLowerPanel, BorderLayout.SOUTH);
		
		gbc2.weighty = 1.0;
		gbl2.setConstraints(middleRightLowerPanel, gbc2);
	
		
		middleRightPanel.add(middleRightLowerPanel);
		
		middlePanel.add(middleRightPanel);
		
		this.add(middlePanel, BorderLayout.CENTER);
		
		JLabel frameCountLabel = new JLabel("Number of " + labelAddition + " Frames:");
		totalFrameCount = new JTextArea();
		totalFrameCount.setBorder(BorderFactory.createLoweredBevelBorder());
		totalFrameCount.setPreferredSize(new Dimension(50, 21));
		totalFrameCount.setMinimumSize(new Dimension(50, 21));
		totalFrameCount.setMaximumSize(new Dimension(50, 21));
		totalFrameCount.setText("0");
		
		//need to set up the JTextArea to affect the JList.
		
		
		JPanel upperPanel = new JPanel();
		
		upperPanel.setLayout(flowLayoutUpper);
		upperPanel.add(frameCountLabel);
		upperPanel.add(totalFrameCount);
		
		changeFrameCountButton = new JButton("Change Frame Count");

		ActionListener changeFrameCountListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				uponPanelCountChange();
			}
		};
		
		changeFrameCountButton.addActionListener(changeFrameCountListener);
		
		upperPanel.add(changeFrameCountButton);
		
		this.add(upperPanel, BorderLayout.NORTH);
		
		JPanel lowerPanel = new JPanel();
		lowerPanel.setLayout(new GridLayout(1, 4));
		
		if(shouldHaveOkCancelButtons) {
			
			JButton cancelButton = new JButton("Cancel");
			cancelButton.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent arg0) {
					finalResult = null;
					parent.setVisible(false);
					parent.dispose();
				}
			});
			lowerPanel.add(cancelButton);
			
			lowerPanel.add(new JPanel());
			lowerPanel.add(new JPanel());
			
			JButton okButton = new JButton("OK");
			okButton.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent e) {
					
					if(!validateIsReadyToBeSaved("Widget Creator"))
						return;
					
					if(additionalValidations != null) {
						String result = additionalValidations.performSecondaryOkValidationsReturnErrors();
						if(result != null) {
							JOptionPane.showMessageDialog(null, "Errors occurred:\n\n" + result, "Unable to create", JOptionPane.WARNING_MESSAGE);
							return;
						}
					}
					
					int countOfItems = listModel.getSize();
					
					if(countOfItems > 0) {
						ListedCustomImage lci;
						ArrayList<CustomImageDataII> imagesList = new ArrayList<CustomImageDataII>();
						for(int i = 0; i < countOfItems; i++) {
							lci = (ListedCustomImage) listModel.get(i);
							if(lci.getImage() == null || lci.getFileName() == null) {
								JOptionPane.showMessageDialog(parent, "Some of the images in the list are blank!","Some Images are Blank!", JOptionPane.WARNING_MESSAGE);
								return;
							}
							imagesList.add(new CustomImageDataII(lci.getImage(), lci.getDesiredWidth(), lci.getDesiredHeight(), lci.getTransparentColor(), parent, lci.getFileName(), false));
						}
						
						finalResult = imagesList.toArray(new CustomImageDataII[0]);
						
					} else {
						
						JOptionPane.showMessageDialog(parent, "You haven't selected any images, yet!","No images selected!", JOptionPane.WARNING_MESSAGE);
						
						return;
					}
					
					
					
					parent.setVisible(false);
					
					
				}
			});
			lowerPanel.add(okButton);
		}
		
		this.add(lowerPanel, BorderLayout.SOUTH);
		
	}
	
	
	public boolean uponPanelCountChangeOld() {
		
//		System.out.println("now in uponPanelCountChange");
		
		if(totalFrameCount == null) {
//			System.out.println("totalFrameCount was null!");
			return true;
		}
		
		String newFrameCountStr = totalFrameCount.getText();
		
		int newFrameCount;
		
		try {
			newFrameCount = Integer.parseInt(newFrameCountStr);
		} catch(NumberFormatException e) {
			JOptionPane.showMessageDialog(null, "Please enter a number.");
			totalFrameCount.setText(Integer.toString(listModel.getSize()));
			totalFrameCount.requestFocus();
			return false;
		}
		
		int oldFrameCount = listModel.getSize();
		
		if(oldFrameCount == newFrameCount) {
			
//			System.out.println("oldFrameCount == newFrameCount");
			return true;
		} else if (oldFrameCount > newFrameCount) {
			int confirmation = JOptionPane.showConfirmDialog(null, "This will delete some frames.  Do you want this?", "Confirm Delete", JOptionPane.YES_NO_OPTION);
			if(confirmation == JOptionPane.YES_OPTION) {
				
				//TODO:  create the EditEvent
				
				for(int i = newFrameCount; i < oldFrameCount; i++) {
					listModel.remove(newFrameCount);
				}
//				System.out.println("removed some frames");
			} else {
				
				totalFrameCount.setText(Integer.toString(listModel.getSize()));
				
//				System.out.println("did a cancel op as per user decision");
				
				return false;
			}
		} else {
			for(int i = oldFrameCount; i < newFrameCount; i++) {
				
				ListedCustomImage li = new ListedCustomImage(null, 0, 0, null, null, "c:\\a_folder\\b_folder/c_folder/blank");
				
				listModel.add(oldFrameCount, li);
			}
			
//			System.out.println("added some records to the JList");
			
		}
		
//		System.out.println("at the end, returning true.");
		return true;
		
	}
	
	public void uponPanelCountChange() {
		
		if(totalFrameCount == null) {
//			System.out.println("totalFrameCount was null!");
			return;
		}
		
		String newFrameCountStr = totalFrameCount.getText();
		
		int newFrameCount;
		
		try {
			newFrameCount = Integer.parseInt(newFrameCountStr);
		} catch(NumberFormatException e) {
			JOptionPane.showMessageDialog(null, "Please enter a number.");
			totalFrameCount.setText(Integer.toString(listModel.getSize()));
			totalFrameCount.requestFocus();
			return;
		}
		
//		System.out.println("newFrameCount is: " + newFrameCount);
		
//		mainPanel.modifyMultiTabCustomImageListChangeCount(listComponent, 
//														   listModel, 
//														   newFrameCount, 
//														   totalFrameCount, 
//														   tabsToJumpTo, 
//														   indexesToJumpTo);
		
		int previousSize = listModel.getSize();
		
		if(newFrameCount > previousSize) {
			
			for(int i = 0; i < (newFrameCount - previousSize); i++) {
				listModel.addElement(new ListedCustomImage(null,0,0,null,null,"blank"));
			}
			
		} else if(newFrameCount < previousSize) {
			
			for(int i = newFrameCount; i < previousSize; i++) {
//				System.out.println("about to remove element at index " + i);
				listModel.removeElementAt(newFrameCount);
			}
			
		}
		
		
	}
	
	
	public void selectImageIntoList() {
		int selectedIndex = listComponent.getSelectedIndex();
		
		if(selectedIndex == -1) {
			JOptionPane.showMessageDialog(null, "You must select an image from the list in order to set the image.", "Error", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		ListedCustomImage newImage = ListedCustomImage.letUserSelectImage("Select Background Image", parent, this);
		
		if(newImage == null)
			return;
		
		
		if(defaultTransparentColor != null) {
			newImage.setTransparentColor(defaultTransparentColor);
		}
		
		//TODO create an edit event for this
		
//		mainPanel.modifyMultiTabCustomImageListOneImage(this.listComponent,
//												   this.listModel,
//												   selectedIndex,
//												   newImage,
//												   this.tabsToJumpTo,
//												   this.indexesToJumpTo);
		
		listModel.setElementAt(newImage, selectedIndex);
		listSelectionChanged();
	}
	
	
	public void listSelectionChanged() {
		
		int selectedIndex = listComponent.getSelectedIndex();
		
		if(selectedIndex == -1) {
			
//			hugePreviewScreen.setIcon(null);
//			hugePreviewScreen.setText("No image selected");
			
			hugePreviewScreen.setListedImage(null);
			hugePreviewScreen.refresh();
			
			browseImageButton.setEnabled(false);
			removeImageButton.setEnabled(false);
			upButton.setEnabled(false);
			downButton.setEnabled(false);
			
			return;
			
		}
		
		backgroundColorCanvas.refresh();
		
		browseImageButton.setEnabled(true);
		removeImageButton.setEnabled(true);
		upButton.setEnabled(true);
		downButton.setEnabled(true);
		
		
		Object o = listModel.getElementAt(selectedIndex);
		
		if(o == null || !(o instanceof ListedCustomImage)) {
//			hugePreviewScreen.setIcon(null);
//			hugePreviewScreen.setText("No image selected");
			
			hugePreviewScreen.setListedImage(null);
			hugePreviewScreen.refresh();
			
			widthTextArea.setText("0");
			heightTextArea.setText("0");
			
			return;
		}
		
		ListedCustomImage newImage = (ListedCustomImage) o;
		
		if(newImage.getImage() == null) {
//			hugePreviewScreen.setIcon(null);
//			hugePreviewScreen.setText("No image selected");
			
			hugePreviewScreen.setListedImage(null);
			hugePreviewScreen.refresh();
			
			widthTextArea.setText(Integer.toString(newImage.getDesiredWidth()));
			heightTextArea.setText(Integer.toString(newImage.getDesiredHeight()));
			
//			System.out.println("no image in this one!  It should've been cleared off by now...");
			
			return;
		}
		
		
		
		//Graphics g = hugePreviewScreen.getGraphics();
		
//		Icon icon = null;
//		
//		icon = new ImageIcon(newImage.getImage());
		
//		hugePreviewScreen.setIcon(icon);
//		hugePreviewScreen.setText(null);
		
		hugePreviewScreen.setListedImage(newImage.getImage());
		hugePreviewScreen.setNewParms(newImage);
		hugePreviewScreen.refresh();
		
		widthTextArea.setText(Integer.toString(newImage.getDesiredWidth()));
		heightTextArea.setText(Integer.toString(newImage.getDesiredHeight()));
		
		//TODO:  add code here that sets the background color
		
		
	}
	
	public void removeImageFromList() {
		
		int selectedIndex = listComponent.getSelectedIndex();
		
		if(selectedIndex == -1) {
			JOptionPane.showMessageDialog(null, "You must select an image from the list in order to clear the image.", "Error", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		ListedCustomImage blankImage = new ListedCustomImage(null, 0,0,null,null,"blank");
		
//		mainPanel.modifyMultiTabCustomImageListOneImage(this.listComponent,
//				   this.listModel,
//				   selectedIndex,
//				   blankImage,
//				   this.tabsToJumpTo,
//				   this.indexesToJumpTo);

		listModel.setElementAt(blankImage, selectedIndex);
		listSelectionChanged();
		
	}
	
	public void removeAllImagesFromList() {
		
		int size = listModel.getSize();
		
		for(int i = 0; i < size; i++) {
			listModel.setElementAt(new ListedCustomImage(null, 0, 0, null,null,"blank"), i);
		}
		
//		mainPanel.modifyMultiTabCustomImageListClearAll(listComponent,
//				                                   listModel,
//				                                   this.tabsToJumpTo,
//				                				   this.indexesToJumpTo);
		
		
	}
	
	public void moveImageUp() {
		
		int selectedIndex = listComponent.getSelectedIndex();
		
		if(selectedIndex < 1)
			return;
		
		ListedCustomImage destinationImage = (ListedCustomImage) listModel.getElementAt(selectedIndex - 1);
		ListedCustomImage sourceImage = (ListedCustomImage) listModel.getElementAt(selectedIndex);
		
//		mainPanel.modifyMultiTabCustomImageListMoveImage(listComponent, listModel, selectedIndex, selectedIndex - 1, 
//				sourceImage, destinationImage, this.tabsToJumpTo, this.indexesToJumpTo);
		
		listModel.setElementAt(sourceImage, selectedIndex - 1);
		listModel.setElementAt(destinationImage, selectedIndex);
		
		
//		listModel.setElementAt(listModel.getElementAt(selectedIndex), selectedIndex - 1);
//		listModel.setElementAt(temp, selectedIndex);
		
		listComponent.setSelectedIndex(selectedIndex - 1);
		
	}
	
	public void moveImageDown() {
		
		int selectedIndex = listComponent.getSelectedIndex();
		
		if(selectedIndex == -1 || selectedIndex >= (listModel.getSize() - 1)) {
			return;
		}
		
		
		ListedCustomImage destinationImage = (ListedCustomImage) listModel.getElementAt(selectedIndex + 1);
		ListedCustomImage sourceImage = (ListedCustomImage) listModel.getElementAt(selectedIndex);
		
//		mainPanel.modifyMultiTabCustomImageListMoveImage(listComponent, listModel, selectedIndex, selectedIndex + 1, 
//				sourceImage, destinationImage, this.tabsToJumpTo, this.indexesToJumpTo);
		
		
		listModel.setElementAt(sourceImage, selectedIndex + 1);
		listModel.setElementAt(destinationImage, selectedIndex);
		
//		ListedImage temp = (ListedImage) listModel.getElementAt(selectedIndex + 1);
//		
//		listModel.setElementAt(listModel.getElementAt(selectedIndex), selectedIndex + 1);
//		listModel.setElementAt(temp, selectedIndex);
//		
		listComponent.setSelectedIndex(selectedIndex + 1);
		
	}
	
	public void popUpPreviewWindow() {
		
		if(listModel.getSize() == 0) {
			JOptionPane.showMessageDialog(null, "There are no frames at all in the list!", "Preview Unavailable", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		ListedCustomImage temp = null;
		
		for(int i = 0; i < listModel.getSize(); i++) {
			
			temp = (ListedCustomImage) listModel.get(i);
			
			if(temp == null || temp.getImage() == null) {
				JOptionPane.showMessageDialog(null, "Please set all the images before starting a preview.", "Preview Unavailable", JOptionPane.ERROR_MESSAGE);
				return;
			}
			
		}
		
		Image backdrop = null;
		BackdropListedImage bli = (BackdropListedImage) backdropListModel.getElementAt(backdropList.getSelectedIndex());
		backdrop = bli.getPreviewBackdropImage();
		
		CustomAnimationPreviewPopupPane.showPopUp(listModel, backdrop);
		
	}
	
	public BackgroundFileData getFileData() {
		
		int listSize = listModel.getSize();
		
		BackgroundFileData returnValue = new BackgroundFileData();
		
		ListedImage temp = null;
		for(int i = 0; i < listSize; i++) {
			temp = (ListedImage) listModel.getElementAt(i);
			returnValue.addFileName(temp.getFileName());
		}
		
		return returnValue;
		
	}
	
	/*public void setBackgroundData(BackgroundFileData fileData) {
		
		listModel.clear();
		
		ArrayList<String> filenameList = fileData.getFilenameList();
		
		ListedCustomImage tempListedImage = null;
		Image tempImage = null;
		File tempFile = null;
		
		
		for(String fileName : filenameList) {

			tempImage = null;
			
			tempFile = new File(fileName);
			if(!tempFile.exists()) {
				ClassLoader cl = BackgroundPanel.class.getClassLoader();
				URL imageURL = cl.getResource("/images\\up_threshold.JPG");
				tempImage = Toolkit.getDefaultToolkit().createImage(imageURL);
			}
			
			try {
				tempImage = ImageIO.read(tempFile);
				if(tempImage == null) {
					ClassLoader cl = BackgroundPanel.class.getClassLoader();
					URL imageURL = cl.getResource("/images\\up_threshold.JPG");
					tempImage = Toolkit.getDefaultToolkit().createImage(imageURL);
				}
			} catch (IOException e) {
				ClassLoader cl = BackgroundPanel.class.getClassLoader();
				URL imageURL = cl.getResource("/images\\up_threshold.JPG");
				tempImage = Toolkit.getDefaultToolkit().createImage(imageURL);
			}
			
			tempListedImage = new ListedCustomImage(fileName, tempImage);
			
			listModel.addElement(tempListedImage);
			
		}
		
		
	}*/
	
	
	
	public void popUpColorSelectDialog() {
		
		if(listComponent == null || listComponent.getSelectedIndex() < 0) {
			
			JOptionPane.showMessageDialog(null, "No image has been selected!", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		int selectedIndex = listComponent.getSelectedIndex();
		
		ListedCustomImage theImage = (ListedCustomImage) listModel.get(selectedIndex);
		
		JDialog colorPopupDialog = new JDialog();
		BackgroundColorPopUpPanel colorPopupPanel = new BackgroundColorPopUpPanel(theImage.getTransparentColor(), colorPopupDialog, true);
		
		colorPopupDialog.setContentPane(colorPopupPanel);
		
//		System.out.println("about to call colorPopupDialog.setVisible...");
		
		colorPopupDialog.setVisible(true);
		
		
		Color newBgColor = colorPopupPanel.getResultColor();

		boolean shouldUseColorForAllImages = colorPopupPanel.shouldUseColorForAllImages();
		
//		System.out.println("shouldUseColorForAllImages is: " + shouldUseColorForAllImages);
		
		
		
		
		if(newBgColor == null) {
			
//			System.out.println("no color was selected!");
			
		} else {
//			System.out.println("just returned from colorPopupDialog.setVisible!  red: " + newBgColor.getRed() + ", green:  " + newBgColor.getGreen() + ", blue: " + newBgColor.getBlue());
			
			
			if(shouldUseColorForAllImages) {
				
//				mainPanel.modifyMultiTabImageListAllImageColors(listModel, this, newBgColor, tabsToJumpTo, indexesToJumpTo);
				
				defaultTransparentColor = newBgColor;
				
				int countOfImages = listModel.getSize();
				for(int i= 0; i < countOfImages; i++) {
					if(listModel.get(i) != null && (listModel.get(i) instanceof ListedCustomImage)) {
						((ListedCustomImage)listModel.get(i)).setTransparentColor(newBgColor);
					}
				}
				
			} else {
				defaultTransparentColor = null;
//				mainPanel.modifyMultiTabImageListOneImageColor(
//						listComponent, 
//						listModel, 
//						listComponent.getSelectedIndex(), 
//						newBgColor, 
//						this, 
//						tabsToJumpTo, 
//						indexesToJumpTo);
				theImage.setTransparentColor(newBgColor);
			}
			
			listSelectionChanged();
		}
		
	}
	
	public void onClickSetWidth() {
		
		if(listComponent == null || listComponent.getSelectedIndex() < 0) {
			JOptionPane.showMessageDialog(null, "You must select an image before you can set its width!", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		ListedCustomImage lci = (ListedCustomImage) listModel.get(listComponent.getSelectedIndex());
		
		
		if(lci == null || lci.getImage() == null) {
			JOptionPane.showMessageDialog(null, "The image selected was not a real image.", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		int widthInt = 0;
		
		try {
			widthInt = Integer.parseInt(widthTextArea.getText());
		} catch(NumberFormatException nfe) {
			JOptionPane.showMessageDialog(null, "The amount entered for the width was not a number", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
//		mainPanel.modifyMultiTabImageListOneImageWidth(listComponent, listModel, listComponent.getSelectedIndex(), widthInt, this, tabsToJumpTo, indexesToJumpTo);
		
		lci.setWidth(widthInt);
		
		listSelectionChanged();
		
	}
	
	public void onClickSetHeight() {
		
		if(listComponent == null || listComponent.getSelectedIndex() < 0) {
			JOptionPane.showMessageDialog(null, "You must select an image before you can set its width!", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		ListedCustomImage lci = (ListedCustomImage) listModel.get(listComponent.getSelectedIndex());
		
		
		if(lci == null || lci.getImage() == null) {
			JOptionPane.showMessageDialog(null, "The image selected was not a real image.", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		int heightInt = 0;
		
		try {
			heightInt = Integer.parseInt(heightTextArea.getText());
		} catch(NumberFormatException nfe) {
			JOptionPane.showMessageDialog(null, "The amount entered for the height was not a number", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}

//		mainPanel.modifyMultiTabImageListOneImageHeight(listComponent, listModel, listComponent.getSelectedIndex(), heightInt, this, tabsToJumpTo, indexesToJumpTo);
		
		lci.setHeight(heightInt);

		listSelectionChanged();
		
	}


	public Color getDefaultTransparentColor() {
		return defaultTransparentColor;
	}


	public void setDefaultTransparentColor(Color defaultTransparentColor) {
		this.defaultTransparentColor = defaultTransparentColor;
	}
	
	public void copyAll(CustomAnimationPanel other) {
		
		if(this == other) {
//			System.out.println("zzzzzzzzzzzzzzzzzzzz  it's trying to do a self-copy!  FAILZZZ!!!");
			return;
		}
		
		this.listModel.clear();
		
		for(int i = 0; i < other.listModel.getSize(); i++) {
			this.listModel.addElement(other.listModel.get(i));
		}
		
		this.listComponent.setSelectedIndex(0);
		
		this.listSelectionChanged();
		
	}
	
	public boolean validateIsReadyToBeCopied() {
		
		if(listModel == null || listModel.getSize() == 0) {
			JOptionPane.showMessageDialog(null, "The panel you're trying to copy from has no images in it.", "Unable to copy.", JOptionPane.ERROR_MESSAGE);
			return false;
		}
		
		ListedCustomImage lci = null;
		
		for(int i = 0; i < listModel.getSize(); i++ ) {
			lci = (ListedCustomImage) listModel.get(i);
			if(lci.getTransparentColor() == null) {
				JOptionPane.showMessageDialog(null, "In the panel you're trying to copy from, the background color for image number " + (i + 1) + " and possibly other images has not been set.", "Unable to copy.", JOptionPane.ERROR_MESSAGE);
				return false;
			}
		}
		
		return true;
	}
	
	public boolean validateIsReadyToBeCopied(String errorMessageIdentifier) {
		
		if(listModel == null || listModel.getSize() == 0) {
			JOptionPane.showMessageDialog(null, "The panel "+errorMessageIdentifier+" you're trying to copy from has no images in it.", "Unable to copy.", JOptionPane.ERROR_MESSAGE);
			return false;
		}
		
		ListedCustomImage lci = null;
		
		for(int i = 0; i < listModel.getSize(); i++ ) {
			lci = (ListedCustomImage) listModel.get(i);
			if(lci == null || lci.getImage() == null) {
				JOptionPane.showMessageDialog(null, "In the panel \""+errorMessageIdentifier+"\" you're trying to copy from, image number " + (i + 1) + " and possibly other images has not been set to any image file.", "Unable to copy.", JOptionPane.ERROR_MESSAGE);
				return false;
			} 
			if(lci.getTransparentColor() == null) {
				JOptionPane.showMessageDialog(null, "In the panel \""+errorMessageIdentifier+"\" you're trying to copy from, the background color for image number " + (i + 1) + " and possibly other images has not been set.", "Unable to copy.", JOptionPane.ERROR_MESSAGE);
				return false;
			}
		}
		
		return true;
	}
	
	public void setFrameCountButtonEnabled(boolean enabled) {
		if(this.changeFrameCountButton != null) {
			this.changeFrameCountButton.setEnabled(enabled);
		}
	}
	
	public boolean getFrameCountButtonEnabled() {
		if(this.changeFrameCountButton == null)
			return false;
		else
			return this.changeFrameCountButton.isEnabled();
	}


//	public int[] getIndexesToJumpTo() {
//		return indexesToJumpTo;
//	}


	public JList getListComponent() {
		return listComponent;
	}


	public DefaultListModel getListModel() {
		return listModel;
	}


//	public JTabbedPane[] getTabsToJumpTo() {
//		return tabsToJumpTo;
//	}


	public JTextArea getTotalFrameCount() {
		return totalFrameCount;
	} 
	
	public void grayOutFrameCount() {
		this.changeFrameCountButton.setEnabled(false);
	}
	
	public void enableFrameCount() {
		this.changeFrameCountButton.setEnabled(true);
	}
	
	public boolean validateIsReadyForPreview(String nameOfScreen) {

		if(listModel.getSize() == 0) {
			JOptionPane.showMessageDialog(null, "There are no images in the panel:  " + nameOfScreen, "Preview Unavailable", JOptionPane.ERROR_MESSAGE);
			return false;
		}
		
		ListedCustomImage temp = null;
		
		for(int i = 0; i < listModel.getSize(); i++) {
			
			temp = (ListedCustomImage) listModel.get(i);
			
			if(temp == null || temp.getImage() == null) {
				JOptionPane.showMessageDialog(null, "Please set all the images before starting a preview; image number " + (i + 1) + " in: " + nameOfScreen + " was not set.", "Preview Unavailable", JOptionPane.ERROR_MESSAGE);
				return false;
			}
			
		}
		
		return true;
	}
	
	public ListedCustomImage[] getImageArray() {
		
		int size = listModel.getSize();
		ListedCustomImage returnValue[] = new ListedCustomImage[size];
		
		for(int i = 0; i < size; i++) {
			returnValue[i] = (ListedCustomImage) listModel.get(i);
		}
		
		return returnValue;
	}
	
	public ListedCustomImage[] getListedImageArray() {
		
		int size = listModel.getSize();
		ListedCustomImage returnValue[] = new ListedCustomImage[size];
		
		for(int i = 0; i < size; i++) {
			returnValue[i] = (ListedCustomImage) listModel.get(i);
		}
		
		return returnValue;
	}
	
	
	public BufferedImage[] getTransparentedImageArray() {
		
		int size = listModel.getSize();
		BufferedImage returnValue[] = new BufferedImage[size];
		
		BufferedImage tempIm;
		Color tempCol;
		
		for(int i = 0; i < size; i++) {
			tempIm = ((ListedCustomImage) listModel.get(i)).getImage();
			tempCol = ((ListedCustomImage) listModel.get(i)).getTransparentColor();
			
			returnValue[i] = CustomImageDataII.makeImageTransparent(tempIm, tempCol);
		}
		
		return returnValue;
	}
	
	
	public String returnAnimationAsFileString() {
		
		StringWriter writer = new StringWriter();
		BufferedWriter out = new BufferedWriter(writer);
		
		ListedCustomImage images[] = getListedImageArray();
		
		try {
			
			out.write(Integer.toString(images.length));
			out.newLine();
			
			for(int i = 0; i < images.length; i++) {
				
				out.write(images[i].getFileName());
				out.newLine();
				out.write(convertColorToString(images[i].getTransparentColor()));
				out.newLine();
				out.write(Integer.toString(images[i].getDesiredWidth()));
				out.newLine();
				out.write(Integer.toString(images[i].getDesiredHeight()));
				out.newLine();
				
			}
			
			out.close();
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
			JOptionPane.showMessageDialog(null, "Error occurred: " + e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		
		return writer.getBuffer().toString();
		
	}
	
	public static String convertColorToString(Color color) {
		
		if(color == null) {
			return "null";
		}
		return color.getRed() + ":" + color.getGreen() + ":" + color.getBlue();
		
	}
	
	public static Color convertStringToColor(String str) {
		
		if(str == null || str.trim().equalsIgnoreCase("null"))
			return null;
		
		int redInt;
		int greenInt;
		int blueInt;
		
		String componentArray[] = str.split(":");
		
		redInt = Integer.parseInt(componentArray[0]);
		greenInt = Integer.parseInt(componentArray[1]);
		blueInt = Integer.parseInt(componentArray[2]);
		
		return new Color(redInt, greenInt, blueInt);
		
	}
	
	
	public void loadFromBufferedReader(BufferedReader in) throws IOException {
		
		String inputter = null;
		
		inputter = in.readLine();
		
//		System.out.println("<><>DELME now in loadFromBufferedReader; inputter is: " + inputter);
		
		int countOfFrames = Integer.parseInt(inputter);
		
		ListedCustomImage tempLCI = null;
		BufferedImage tempImage = null;
		Color tempColor = null;
		int tempWidth;
		int tempHeight;
		String tempFileName = null;
		
		for(int i = 0; i < countOfFrames; i++) {
			
			inputter = in.readLine();
			tempFileName = inputter;
			if(inputter != null && inputter.length() > 0 && !inputter.trim().equalsIgnoreCase("blank"))
				tempImage = ImageIO.read(new File(inputter));
			else tempImage = null;
			
			inputter = in.readLine();
			tempColor = convertStringToColor(inputter);
			
			inputter = in.readLine();
			tempWidth = Integer.parseInt(inputter);
			
			inputter = in.readLine();
			tempHeight = Integer.parseInt(inputter);
			
			tempLCI = new ListedCustomImage(tempImage, tempWidth, tempHeight, tempColor, null, tempFileName);
			
			listModel.addElement(tempLCI);
			
		}
		
		listSelectionChanged();
		
		totalFrameCount.setText(Integer.toString(countOfFrames));
		
	}
	
	public void cleanSlate() {
		
		listModel.clear();
		totalFrameCount.setText("0");
		listSelectionChanged();
		
		defaultTransparentColor = null;
		
		backdropList.setSelectedIndex(0);
		
	}
	
	public void saveToBufferedWriter(BufferedWriter out) throws IOException {
		
		int countOfFrames = listModel.getSize();
		
		out.write(Integer.toString(countOfFrames));
		out.newLine();
		
		String tempFileName;
		Color tempColor;
		int tempWidth;
		int tempHeight;
		
		ListedCustomImage tempLCI;
		
		for(int i = 0; i < countOfFrames; i++) {
			
			tempLCI = (ListedCustomImage) listModel.getElementAt(i);
			
			tempFileName = tempLCI.getFileName();
			tempColor = tempLCI.getTransparentColor();
			tempWidth = tempLCI.getDesiredWidth();
			tempHeight = tempLCI.getDesiredHeight();
			
			out.write(tempFileName);
			out.newLine();
			out.write(convertColorToString(tempColor));
			out.newLine();
			out.write(Integer.toString(tempWidth));
			out.newLine();
			out.write(Integer.toString(tempHeight));
			out.newLine();
			
		}
		
	}
	
	
	public boolean validateIsReadyToBeSaved(String errorMessageIdentifier) {
		
		if(listModel == null || listModel.getSize() == 0) {
			JOptionPane.showMessageDialog(null, "The panel "+errorMessageIdentifier+" has no images in it.", "Unable to save.", JOptionPane.ERROR_MESSAGE);
			return false;
		}
		
		ListedCustomImage lci = null;
		
		for(int i = 0; i < listModel.getSize(); i++ ) {
			lci = (ListedCustomImage) listModel.get(i);
			if(lci == null || lci.getImage() == null) {
				JOptionPane.showMessageDialog(null, "In the panel \""+errorMessageIdentifier+"\", image number " + (i + 1) + " and possibly other images has not been set to any image file.", "Unable to save.", JOptionPane.ERROR_MESSAGE);
				return false;
			} 
			if(lci.getTransparentColor() == null) {
				JOptionPane.showMessageDialog(null, "In the panel \""+errorMessageIdentifier+"\" the transparent color for image number " + (i + 1) + " and possibly other images has not been set.", "Unable to save.", JOptionPane.ERROR_MESSAGE);
				return false;
			}
		}
		
		return true;
	}
	
	
	public CustomImageDataII[] getFinalResult() {
		return finalResult;
	}
	
	
	public CustomAnimationPanel (JDialog theParent, 
            String labelAddition,
            String caption,
            CustomImageDataII origResult[]) {
		this(theParent, labelAddition, caption, origResult, true);
	}

	public CustomAnimationPanel (JDialog theParent, 
			                     String labelAddition,
			                     String caption,
			                     CustomImageDataII origResult[],
			                     boolean shouldHaveOkCancel) {
		
		parent = theParent;
		
//		tabsToJumpTo = theTabbedPaneArray;
//		indexesToJumpTo = theIndexArray;
		
		backdropImages = new BackdropListedImage[23];
		
		ImageIcon tempIcon = null;
		ImageIcon tempPrevIcon = null;
		BackdropListedImage tempImage = null;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_check.GIF"));
		tempImage = new BackdropListedImage("Silver&White L", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[0] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_mini_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_mini_check.GIF"));
		tempImage = new BackdropListedImage("Silver&White M", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[1] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_micro_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_micro_check.GIF"));
		tempImage = new BackdropListedImage("Silver&White S", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[2] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_check.GIF"));
		tempImage = new BackdropListedImage("Black&White L", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[3] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_mini_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_mini_check.GIF"));
		tempImage = new BackdropListedImage("Black&White M", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[4] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_micro_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_micro_check.GIF"));
		tempImage = new BackdropListedImage("Black&White S", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[5] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_check.GIF"));
		tempImage = new BackdropListedImage("Red&Cyan L", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[6] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_mini_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_mini_check.GIF"));
		tempImage = new BackdropListedImage("Red&Cyan M", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[7] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_micro_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_micro_check.GIF"));
		tempImage = new BackdropListedImage("Red&Cyan S", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[8] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_check.GIF"));
		tempImage = new BackdropListedImage("Yellow&Blue L", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[9] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_mini_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_mini_check.GIF"));
		tempImage = new BackdropListedImage("Yellow&Blue M", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[10] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_micro_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_micro_check.GIF"));
		tempImage = new BackdropListedImage("Yellow&Blue S", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[11] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_check.GIF"));
		tempImage = new BackdropListedImage("Green&Magenta L", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[12] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_mini_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_mini_check.GIF"));
		tempImage = new BackdropListedImage("Green&Magenta M", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[13] = tempImage;
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_micro_check.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_micro_check.GIF"));
		tempImage = new BackdropListedImage("Green&Magenta S", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[14] = tempImage;
		
		
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/white.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_white.GIF"));
		tempImage = new BackdropListedImage("Solid White", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[15] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black.GIF"));
		tempImage = new BackdropListedImage("Solid Black", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[16] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red.GIF"));
		tempImage = new BackdropListedImage("Solid Red", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[17] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow.GIF"));
		tempImage = new BackdropListedImage("Solid Yellow", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[18] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green.GIF"));
		tempImage = new BackdropListedImage("Solid Lime", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[19] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/cyan.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_cyan.GIF"));
		tempImage = new BackdropListedImage("Solid Cyan", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[20] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/blue.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_blue.GIF"));
		tempImage = new BackdropListedImage("Solid Blue", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[21] = tempImage;
		
		tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/magenta.GIF"));
		tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_magenta.GIF"));
		tempImage = new BackdropListedImage("Solid Magenta", tempIcon.getImage(), tempPrevIcon.getImage());
		backdropImages[22] = tempImage;
		
		
		
		BorderLayout borderLayout = new BorderLayout();
		
		this.setLayout(borderLayout);
		
		JPanel middlePanel = new JPanel();
		JPanel middleLeftPanel = new JPanel();
		JPanel middleLeftInnerPanel = new JPanel();
		JPanel middleLeftLowerPanel = new JPanel();
		JPanel middleRightPanel = new JPanel();
		JPanel middleRightInnerPanel = new JPanel();
		JPanel middleRightLowerPanel = new JPanel();
		
		GridLayout gridLayout = new GridLayout(1, 2);
		BorderLayout borderLayoutLeft = new BorderLayout();
		GridBagLayout gridLayoutLeftLower = new GridBagLayout();
		BorderLayout borderLayoutRight = new BorderLayout();
		GridBagLayout gridLayoutRightLower = new GridBagLayout();
		FlowLayout flowLayoutLeft = new FlowLayout();
		FlowLayout flowLayoutRight = new FlowLayout();
		FlowLayout flowLayoutUpper = new FlowLayout();
		
		middlePanel.setLayout(gridLayout);
		
		hugePreviewScreen = new PreviewCanvas(false, this, false);
		hugePreviewScreen.setBackdropImage(backdropImages[0].getImage());
//		hugePreviewScreen.setAlignmentX(JLabel.CENTER_ALIGNMENT);
//		hugePreviewScreen.setAlignmentY(JLabel.CENTER_ALIGNMENT);
//		
//		
//		hugePreviewScreen.setPreferredSize(new Dimension(200, 200));
//		hugePreviewScreen.setMinimumSize(new Dimension(200, 200));
//		hugePreviewScreen.setMaximumSize(new Dimension(200, 200));
		
//		Border hugePreviewScreenBorder = BorderFactory.createLineBorder(new Color(0,0,0));
//		
//		hugePreviewScreen.setBorder(hugePreviewScreenBorder);
		
		
		listModel = new DefaultListModel();
		listComponent = new JList(listModel);
		listComponent.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		listComponent.addListSelectionListener(new ListSelectionListener() {
			
			public void valueChanged(ListSelectionEvent arg0) {
				// TODO Auto-generated method stub
				
				listSelectionChanged();
			}
			
		});
		
		if(origResult != null) {
			ArrayList<ListedCustomImage> tempImageList = new ArrayList<ListedCustomImage>();
			try {
				ListedCustomImage lci = null;
				BufferedImage bi = null;
				for(CustomImageDataII cid : origResult) {
					
					if(cid.getFileName().equalsIgnoreCase("blank")) {
						lci = new ListedCustomImage(null,0,0,null,null,"blank");
						tempImageList.add(lci);
						continue;
					} else if(cid.isResource()) {
						bi = ImageIO.read(CustomAnimationPanel.class.getResource(cid.getFileName()));
					} else {
						System.out.println("<><>DELME what is the file name? " + cid.getFileName());
						bi = ImageIO.read(new File(cid.getFileName()));
					}
					
					lci = new ListedCustomImage(bi, cid.getDesiredWidth(), cid.getDesiredHeight(), cid.getTransparentColor(), this, cid.getFileName());
					tempImageList.add(lci);
				}
			} catch (IOException e) {
				JOptionPane.showMessageDialog(null, "Error occurred while loading some of the files: " + e.getMessage(),"Error loading files", JOptionPane.WARNING_MESSAGE);
				tempImageList = null;
			}
			
			if(tempImageList != null) {
				for(ListedCustomImage llci : tempImageList) {
					System.out.println("<><>DELME now adding this listed custom image to the listModel: " + llci.getFileName());
					listModel.addElement(llci);
				}
			}
		}
		
		
		JScrollPane listPane = new JScrollPane();
		listPane.setPreferredSize(new Dimension(200,200));
		listPane.setMinimumSize(new Dimension(200, 200));
		listPane.setMaximumSize(new Dimension(200, 200));
		
		listPane.getViewport().setView(listComponent);
		
		
		LineBorder innerLineBorderLeft = (LineBorder) BorderFactory.createLineBorder(new Color(140, 140, 140));
		TitledBorder titleBorderLeft = new TitledBorder(innerLineBorderLeft, "Frame Preview", TitledBorder.LEFT, TitledBorder.TOP);
		
		middleLeftInnerPanel.setBorder(titleBorderLeft);
		middleLeftInnerPanel.setLayout(flowLayoutLeft);
		middleLeftInnerPanel.add(hugePreviewScreen);
		
		GridBagLayout gbl1 = new GridBagLayout();
		GridBagConstraints gbc1 = new GridBagConstraints();
		
		gbc1.fill = GridBagConstraints.BOTH;
		
		gbc1.gridwidth = GridBagConstraints.REMAINDER;
		gbc1.weightx = 0.0;
		gbc1.weighty = 0.0;
		
		
		
		//middleLeftPanel.setLayout(borderLayoutLeft);
		//middleLeftPanel.add(middleLeftInnerPanel, BorderLayout.CENTER);
		
		middleLeftPanel.setLayout(gbl1);
		
		gbl1.setConstraints(middleLeftInnerPanel, gbc1);
		
		middleLeftPanel.add(middleLeftInnerPanel);
		
		
		
		middleLeftPanel.setPreferredSize(new Dimension(200, 200));
		middleLeftPanel.setMinimumSize(new Dimension(200, 200));
		middleLeftPanel.setMaximumSize(new Dimension(200, 200));
		
		middleLeftLowerPanel.setLayout(gridLayoutLeftLower);
		previewButton = new JButton("Preview...");
		
		
		ActionListener previewListener = new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				popUpPreviewWindow();
			}
		};
		previewButton.addActionListener(previewListener);
		
		JPanel previewAndClearPanel = new JPanel();
		
		previewAndClearPanel.setLayout(new GridLayout(1, 2));
		
//		Border innerPreviewClearBorder = BorderFactory.createLineBorder(new Color(255, 0, 0));
//		TitledBorder previewAndClearBorder = BorderFactory.createTitledBorder(innerPreviewClearBorder, "previewAndClearPanel");
//		
//		previewAndClearPanel.setBorder(previewAndClearBorder);
		
		JPanel previewPanel = new JPanel();
		previewPanel.setLayout(new FlowLayout());
		previewPanel.add(previewButton);
		previewAndClearPanel.add(previewPanel);
		

		clearAllButton = new JButton("Clear All");
		clearAllButton.setAlignmentX(JButton.CENTER_ALIGNMENT);
		
		ActionListener clearAllListener = new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				removeAllImagesFromList();
				hugePreviewScreen.setListedImage(null);
				hugePreviewScreen.refresh();
				
			}
			
		};
		clearAllButton.addActionListener(clearAllListener);
		
		JPanel clearAllPanel = new JPanel(new FlowLayout());
		

//		Border innerClearAllBorder = BorderFactory.createLineBorder(new Color(255, 255, 0));
//		TitledBorder clearAllBorder = BorderFactory.createTitledBorder(innerClearAllBorder, "clearAllPanel");
//		
//		clearAllPanel.setBorder(clearAllBorder);
		
		clearAllPanel.add(clearAllButton);
		previewAndClearPanel.add(clearAllPanel);
		
		
		
		
		GridBagConstraints gridLayoutLeftLowerConstraints = new GridBagConstraints();
		
		gridLayoutLeftLowerConstraints.weightx = 1.0;
		gridLayoutLeftLowerConstraints.weighty = 1.0;
		gridLayoutLeftLowerConstraints.gridwidth = GridBagConstraints.REMAINDER;
		gridLayoutLeftLowerConstraints.fill = GridBagConstraints.BOTH;
		
		
		
		
		gbc1.weighty = 1.0;
		//gbc1.gridheight = GridBagConstraints.REMAINDER;
		
		gridLayoutLeftLower.setConstraints(previewAndClearPanel,gridLayoutLeftLowerConstraints);
		
		middleLeftLowerPanel.add(previewAndClearPanel);
		
		JPanel colorAndDimensionsPanel = new JPanel();
		colorAndDimensionsPanel.setLayout(new GridLayout(4,1));
		
		//colorAndDimensionsPanel.add(new JLabel("the text areas go here"));
		
		GridBagLayout backdropSelectorLayout = new GridBagLayout();
		JPanel backdropSelectorPanel = new JPanel(backdropSelectorLayout);
		
		GridBagConstraints backdropSelectorConstraints = new GridBagConstraints();
		
		backdropSelectorConstraints.fill = GridBagConstraints.BOTH;
		
		backdropSelectorConstraints.gridwidth = GridBagConstraints.RELATIVE;
		backdropSelectorConstraints.weightx = 1.0;
		backdropSelectorConstraints.weighty = 0.0;
		
		JPanel backdropLabelPanel = new JPanel(new FlowLayout());
		backdropLabelPanel.add(new JLabel("Backdrop: "));
		
		backdropSelectorLayout.setConstraints(backdropLabelPanel, backdropSelectorConstraints);
		backdropSelectorPanel.add(backdropLabelPanel);
		
		backdropSelectorConstraints.gridwidth = GridBagConstraints.REMAINDER;
		backdropSelectorConstraints.weightx = 3.0;
		backdropSelectorConstraints.weighty = 0.0;
		
		JPanel backdropListPanel = new JPanel(new FlowLayout());
		
		backdropListModel = new DefaultComboBoxModel();
		backdropList = new JComboBox(backdropListModel);
		backdropListPanel.add(backdropList);
		
		for(ListedImage li : backdropImages) {
			backdropListModel.addElement(li);
		}
		
		backdropList.addItemListener(new ItemListener() {

			public void itemStateChanged(ItemEvent arg0) {
				
//				System.out.println("now in itemStateChanged!");
				
				int index = backdropList.getSelectedIndex();
				if(index < 0)
					index = 0;
				
				ListedImage li = (ListedImage) backdropListModel.getElementAt(index);
				
//				System.out.println("li's name is: " + li.getFileName());
				
				hugePreviewScreen.setBackdropImage(li.getImage());
				listSelectionChanged();
			}
			
		});
		
		backdropSelectorLayout.setConstraints(backdropListPanel, backdropSelectorConstraints);
		
		backdropSelectorPanel.add(backdropListPanel);
		
		colorAndDimensionsPanel.add(backdropSelectorPanel);
		
		GridBagLayout colorPopupLayout = new GridBagLayout();
		JPanel colorPopupPanel = new JPanel(colorPopupLayout);
		
		JPanel colorButtonPanel = new JPanel(new FlowLayout());
		JButton colorPopupButton = new JButton("Set BgColor...");
		colorPopupButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				popUpColorSelectDialog();
			}
			
		});
		colorButtonPanel.add(colorPopupButton);
		
		
		GridBagConstraints colorPopupConstraints = new GridBagConstraints();

		colorPopupConstraints.fill = GridBagConstraints.BOTH;
		
		colorPopupConstraints.gridwidth = GridBagConstraints.RELATIVE;
		colorPopupConstraints.weightx = 1.0;
		colorPopupConstraints.weighty = 0.0;
		
		colorPopupLayout.setConstraints(colorButtonPanel, colorPopupConstraints);
		
		colorPopupPanel.add(colorButtonPanel);
		
		colorPopupConstraints.gridwidth = GridBagConstraints.REMAINDER;
		colorPopupConstraints.weightx = 1.0;
		
		backgroundColorCanvas = new MiniColorCanvas(listComponent, listModel);
		Border loweredBorder = BorderFactory.createEtchedBorder();
		backgroundColorCanvas.setBorder(loweredBorder);
		
		colorPopupLayout.setConstraints(backgroundColorCanvas, colorPopupConstraints);
		colorPopupPanel.add(backgroundColorCanvas);
		
		colorAndDimensionsPanel.add(colorPopupPanel);
		
		JPanel widthPanel = new JPanel(new GridLayout(1, 3));
		widthPanel.add(new JLabel("Width:"));
		JPanel widthTextPanel = new JPanel(new FlowLayout());
		widthTextArea = new JTextArea();
		widthTextArea.setPreferredSize(new Dimension(60, 21));
		widthTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
		widthTextPanel.add(widthTextArea);
		
		widthTextArea.addFocusListener(new FocusListener() {

			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub
				
			}

			public void focusLost(FocusEvent arg0) {
//				System.out.println("lost the focus just now!");
			}
			
		});
		
		
		widthPanel.add(widthTextPanel);
		JPanel widthSetPanel = new JPanel(new FlowLayout());
		widthSetButton = new JButton("Set");
		widthSetButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				onClickSetWidth();
			}
		});
		widthSetPanel.add(widthSetButton);
		widthPanel.add(widthSetPanel);
		colorAndDimensionsPanel.add(widthPanel);  
		
		JPanel heightPanel = new JPanel(new GridLayout(1, 3));
		heightPanel.add(new JLabel("Height:"));
		JPanel heightTextPanel = new JPanel(new FlowLayout());
		heightTextArea = new JTextArea();
		heightTextArea.setPreferredSize(new Dimension(60, 21));
		heightTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
		heightTextPanel.add(heightTextArea);
		heightPanel.add(heightTextPanel);
		JPanel heightSetPanel = new JPanel(new FlowLayout());
		heightSetButton = new JButton("Set");
		heightSetButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				onClickSetHeight();
			}
		});
		heightSetPanel.add(heightSetButton);
		heightPanel.add(heightSetPanel);
		colorAndDimensionsPanel.add(heightPanel);
		
		
		gridLayoutLeftLower.setConstraints(colorAndDimensionsPanel, gridLayoutLeftLowerConstraints);
		
		middleLeftLowerPanel.add(colorAndDimensionsPanel);

		gbl1.setConstraints(middleLeftLowerPanel, gbc1);
		
//		middleLeftPanel.add(middleLeftLowerPanel, BorderLayout.SOUTH);
		middleLeftPanel.add(middleLeftLowerPanel);
		
		middlePanel.add(middleLeftPanel);
		
		middleRightPanel = new JPanel();
//		middleRightPanel.setLayout(borderLayoutRight);
		
		GridBagLayout gbl2 = new GridBagLayout();
		GridBagConstraints gbc2 = new GridBagConstraints();
		
		
		
		middleRightPanel.setLayout(gbl2);
		
		middleRightInnerPanel.setLayout(flowLayoutRight);
		middleRightInnerPanel.add(listPane);
		
		LineBorder innerLineBorderRight = (LineBorder) BorderFactory.createLineBorder(new Color(140, 140, 140));
		TitledBorder titleBorderRight = new TitledBorder(innerLineBorderRight, "List of Frames", TitledBorder.LEFT, TitledBorder.TOP);
		
		middleRightInnerPanel.setBorder(titleBorderRight);
		
//		middleRightPanel.add(middleRightInnerPanel, BorderLayout.CENTER);
		
		gbc2.fill = GridBagConstraints.BOTH;
		gbc2.gridwidth = GridBagConstraints.REMAINDER;
		gbc2.weightx = 0.0;
		gbc2.weighty = 0.0;
		
		gbl2.setConstraints(middleRightInnerPanel, gbc2);
		
		middleRightPanel.add(middleRightInnerPanel);
		GridBagConstraints gbc3 = new GridBagConstraints();
		
		middleRightLowerPanel.setLayout(gridLayoutRightLower);
				
		browseImageButton = new JButton("Browse...");
		browseImageButton.setEnabled(false);
		removeImageButton = new JButton("Clear Image");
		removeImageButton.setEnabled(false);
		
		JPanel selectImagePanel = new JPanel();
		selectImagePanel.setLayout(new FlowLayout());
		
		ActionListener selectImageListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				selectImageIntoList();
			}
		};
		
		browseImageButton.addActionListener(selectImageListener);
		
		selectImagePanel.add(browseImageButton);
		JPanel removeImagePanel = new JPanel();
		removeImagePanel.setLayout(new FlowLayout());
		
		
		JPanel selectMultipleFilesPanel = new JPanel(new FlowLayout());
		JButton selectMultipleFilesButton = new JButton("Multiple Files...");
		selectMultipleFilesButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				JFileChooser jfc = new JFileChooser();
				jfc.setMultiSelectionEnabled(true);
				
				int result = jfc.showOpenDialog(parent);
				
				if(result == JFileChooser.APPROVE_OPTION) {
					
					result = JOptionPane.showConfirmDialog(parent, "This will clear out everything, and replace it with the files that were loaded.  Continue?","Confirm load multiple files", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
					if(result == JOptionPane.NO_OPTION)
						return;
					
					
					File fileArray[] = jfc.getSelectedFiles();
					
					
					
					
					ArrayList<ListedCustomImage> newImages = new ArrayList<ListedCustomImage>();
					ListedCustomImage newImage = null;
					BufferedImage bi = null;
					for(File f : fileArray) {
//						System.out.println("A file: " + f.getAbsolutePath());
						try {
							bi = ImageIO.read(f);
						} catch(Exception e) {
							JOptionPane.showMessageDialog(parent, "Error while trying to load image file: " + f.getAbsolutePath(),"Error loading image",JOptionPane.WARNING_MESSAGE);
							return;
						}
						newImage = new ListedCustomImage(bi, bi.getWidth(), bi.getHeight(), null, parent, f.getAbsolutePath());
						newImages.add(newImage);
					}
					
					
					totalFrameCount.setText(Integer.toString(fileArray.length));
					uponPanelCountChange();
					
					for(int i = 0; i < newImages.size(); i++) {
						listModel.setElementAt(newImages.get(i), i);
					}
					
					
					
				}
				
			}
		});
		selectMultipleFilesPanel.add(selectMultipleFilesButton);
		
		ActionListener removeImageListener = new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				removeImageFromList();
				hugePreviewScreen.setListedImage(null);
				hugePreviewScreen.refresh();
			}
			
		};
		removeImageButton.addActionListener(removeImageListener);
		
		removeImagePanel.add(removeImageButton);
		
		gbc3.fill = GridBagConstraints.BOTH;
		gbc3.gridwidth = GridBagConstraints.RELATIVE;
		gbc3.weightx = 1.0;
		gbc3.weighty = 1.0;
		
		gridLayoutRightLower.setConstraints(selectImagePanel, gbc3);
		middleRightLowerPanel.add(selectImagePanel);
		
		
		gbc3.gridwidth = GridBagConstraints.REMAINDER;
		gridLayoutRightLower.setConstraints(removeImagePanel, gbc3);
		middleRightLowerPanel.add(removeImagePanel);
		
		
		JPanel upAndDownPanel = new JPanel();
		GridLayout upAndDownLayout = null;
		
		if(caption == null) {
			upAndDownLayout = new GridLayout(4,1);
			upAndDownPanel.setLayout(upAndDownLayout);
		} else {
			upAndDownLayout = new GridLayout(5, 1);
			upAndDownPanel.setLayout(upAndDownLayout);
			
			JLabel captionLabel = new JLabel(caption);
			upAndDownPanel.add(captionLabel);
		}
		
		
		
		
		upButton = new JButton("Move Image Up");
		upButton.setEnabled(false);
		JPanel upButtonPanel = new JPanel();
		
		ActionListener upButtonListener = new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				moveImageUp();
			}
		};
		
		upButton.addActionListener(upButtonListener);
		
		
		
		FlowLayout upButtonLayout = new FlowLayout();
		upButtonPanel.setLayout(upButtonLayout);
		upButtonPanel.add(upButton);
		
		downButton = new JButton("Move Image Down");
		downButton.setEnabled(false);
		JPanel downButtonPanel = new JPanel();
		
		ActionListener downButtonListener = new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				moveImageDown();
			}
		};
		downButton.addActionListener(downButtonListener);
		
		
		FlowLayout downButtonLayout = new FlowLayout();
		downButtonPanel.setLayout(downButtonLayout);
		downButtonPanel.add(downButton);
		
		upAndDownPanel.add(upButtonPanel);
		upAndDownPanel.add(downButtonPanel);
		
		upAndDownPanel.add(new JPanel());
		upAndDownPanel.add(selectMultipleFilesPanel); 
		
		
		gbc3.weightx = 3.0;
		
		gridLayoutRightLower.setConstraints(upAndDownPanel, gbc3);
		
		middleRightLowerPanel.add(upAndDownPanel);
		
		
//		middleRightPanel.add(middleRightLowerPanel, BorderLayout.SOUTH);
		
		gbc2.weighty = 1.0;
		gbl2.setConstraints(middleRightLowerPanel, gbc2);
	
		
		middleRightPanel.add(middleRightLowerPanel);
		
		middlePanel.add(middleRightPanel);
		
		this.add(middlePanel, BorderLayout.CENTER);
		
		JLabel frameCountLabel = new JLabel("Number of " + labelAddition + " Frames:");
		totalFrameCount = new JTextArea();
		totalFrameCount.setBorder(BorderFactory.createLoweredBevelBorder());
		totalFrameCount.setPreferredSize(new Dimension(50, 21));
		totalFrameCount.setMinimumSize(new Dimension(50, 21));
		totalFrameCount.setMaximumSize(new Dimension(50, 21));
		if(origResult == null)
			totalFrameCount.setText("0");
		else
			totalFrameCount.setText(Integer.toString(origResult.length));
		
		//need to set up the JTextArea to affect the JList.
		
		
		JPanel upperPanel = new JPanel();
		
		upperPanel.setLayout(flowLayoutUpper);
		upperPanel.add(frameCountLabel);
		upperPanel.add(totalFrameCount);
		
		changeFrameCountButton = new JButton("Change Frame Count");

		ActionListener changeFrameCountListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				uponPanelCountChange();
			}
		};
		
		changeFrameCountButton.addActionListener(changeFrameCountListener);
		
		upperPanel.add(changeFrameCountButton);
		
		this.add(upperPanel, BorderLayout.NORTH);
		
		if(shouldHaveOkCancel) {
			
			JPanel lowerPanel = new JPanel();
			lowerPanel.setLayout(new GridLayout(1, 4));
			
			JButton cancelButton = new JButton("Cancel");
			cancelButton.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent arg0) {
					finalResult = null;
					parent.setVisible(false);
					parent.dispose();
				}
			});
			lowerPanel.add(cancelButton);
			
			lowerPanel.add(new JPanel());
			lowerPanel.add(new JPanel());
			
			JButton okButton = new JButton("OK");
			okButton.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent e) {
					
					if(!validateIsReadyToBeSaved("Widget Creator"))
						return;
					
					if(additionalValidations != null) {
						String result = additionalValidations.performSecondaryOkValidationsReturnErrors();
						if(result != null) {
							JOptionPane.showMessageDialog(null, "Errors occurred:\n\n" + result, "Unable to create", JOptionPane.WARNING_MESSAGE);
							return;
						}
					}
					
					int countOfItems = listModel.getSize();
					
					if(countOfItems > 0) {
						ListedCustomImage lci;
						ArrayList<CustomImageDataII> imagesList = new ArrayList<CustomImageDataII>();
						for(int i = 0; i < countOfItems; i++) {
							lci = (ListedCustomImage) listModel.get(i);
							if(lci.getImage() == null || lci.getFileName() == null) {
								JOptionPane.showMessageDialog(parent, "Some of the images in the list are blank!","Some Images are Blank!", JOptionPane.WARNING_MESSAGE);
								return;
							}
							imagesList.add(new CustomImageDataII(lci.getImage(), lci.getDesiredWidth(), lci.getDesiredHeight(), lci.getTransparentColor(), parent, lci.getFileName(), false));
						}
						
						finalResult = imagesList.toArray(new CustomImageDataII[0]);
						
					} else {
						
						JOptionPane.showMessageDialog(parent, "You haven't selected any images, yet!","No images selected!", JOptionPane.WARNING_MESSAGE);
						
						return;
					}
					
					
					
					parent.setVisible(false);
					
					
				}
			});
			lowerPanel.add(okButton);
			
			this.add(lowerPanel, BorderLayout.SOUTH);
		}
		
	}


	public void setAdditionalValidations(SecondaryOKValidation additionalValidations) {
		this.additionalValidations = additionalValidations;
	}
	
	
	private void copyImage() {
		int index = this.listComponent.getSelectedIndex();
		if(index < 0)
			return;
		
		ListedCustomImage selected = (ListedCustomImage) this.listModel.get(index);
		if(selected == null || selected.getFileName().equals("blank"))
			return;
		
		this.clipboard = new ListedCustomImage(selected.getImage(), selected.getDesiredWidth(), selected.getDesiredHeight(), selected.getTransparentColor(), selected.getObserver(), selected.getFileName());
	}
	
	private void pasteImage() {
		int index = this.listComponent.getSelectedIndex();
		if(index < 0)
			return;
		
		if(this.clipboard == null)
			return;
		
		ListedCustomImage newImage = new ListedCustomImage(clipboard.getImage(), clipboard.getDesiredWidth(), clipboard.getDesiredHeight(), clipboard.getTransparentColor(), clipboard.getObserver(), clipboard.getFileName());
		
		listModel.set(index, newImage);
	}
	
}
